<?php

class RegisterController extends Controller
{
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'SaveRegisterFixedAsset', 'GetList', 'DeleteFixedAssetMaster', 'GetInvoiceFromPurchase', 'CreateSerialize', 'GetSerialNumber'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        //setting the layout as the fixed asset module layout
        $this->layout = 'layout';
        $this->render('index');
    }

    // action to create master fixed asset form
    public function actionCreate(){
        $model = new FixedAssetRegister();
        if (!empty($_GET['id'])) {
            $model = $model->findByPk($_GET['id']);
        }else{
       
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('registerfixedasset', array('model' => $model, 'purchase_orders' => $this->getPurchaseOrders()), false, false);
    }
    
    // action to create master fixed asset form
    public function actionCreateSerialize(){
        $model = new FixedAssetRegister();
        if (!empty($_GET['id'])) {
            $model = $model->findByPk($_GET['id']);
            $type = 'UPDATES';
        }else{
            $type = 'CREATES';
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render(
                            'serialize',
                             array(
                                    'model' => $model,
                                     'master_fixed_asset' => new FixedAssetMaster(),
                                      'product_id' => $_GET['product_id'],
                                      'invoice' => $_GET['invoice'],
                                      'purchase_order' => $_GET['purchase_order'],
                                      'qty' => $_GET['qty'],
                                      'rate' => $_GET['rate'],
                                      'type' => $type
                                    ),
                            false,
                            false
                        );
    }

    // action to save fixed assets register
    public function actionSaveRegisterFixedAsset(){
        if (isset($_POST['FixedAssetRegister'])) {
            try{
                $type = (!empty($_POST['FixedAssetRegister']['id'])) ? 'UPDATES' : 'SAVE';
                if ($type == 'SAVE'){
                    for ($i = 0; $i < (int) $_POST['FixedAssetRegister']['qty']; $i++){
                        $model = new FixedAssetRegister();
                        $model->created_by = Yii::app()->user->id;
                        $model->created_at = date('Y-m-d h:i:s');
                        $model->purchase_order = $_POST['FixedAssetRegister']['purchase_order'];
                        $model->product_id = $_POST['FixedAssetRegister']['product_id']; 
                        $model->invoice_id = $_POST['FixedAssetRegister']['invoice'];
                        $model->isActive = 1;
                        $serial_number = $this->actionGetSerialNumber('array', $_POST['FixedAssetRegister']['fixed_asset_master_number']);
                        if (!empty($serial_number['series_number'])) $model->fixed_asset_register_number = $serial_number['series_number'];
                        else $model->fixed_asset_register_number = $serial_number['existing_series_number'] + 1;
                        $model->description = $_POST['FixedAssetRegister']['description'];
                        $model->fixed_asset_master_number = $_POST['FixedAssetRegister']['fixed_asset_master_number'];
                        $model->depreciation_start_date = date("Y-m-d h:i", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['depreciation_start_date']))); 
                        $model->current_book_value = $_POST['FixedAssetRegister']['rate'];;
                      
                             if ($model->save()){
                                $jsonData['status'] = 'success';
                             }else{
                                 // check for validation errors from the form and displaying the errors back
                                 echo CActiveForm::validate($model);
                                 exit;
                             }
                        }
                }

                if ($type == 'UPDATES'){
                    $model = new FixedAssetRegister();
                    $model = $model->findByPk($_POST['FixedAssetRegister']['id']);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_at = date('Y-m-d h:i:s');
                    $model->description = $_POST['FixedAssetRegister']['description'];
                    $model->location = $_POST['FixedAssetRegister']['location'];
                    $model->department = $_POST['FixedAssetRegister']['department'];
                    $model->used_by = $_POST['FixedAssetRegister']['used_by'];
                    $model->serial_number = $_POST['FixedAssetRegister']['serial_number'];
                    if ($model->save()){
                        $jsonData['status'] = 'success';
                     }else{
                         // check for validation errors from the form and displaying the errors back
                         echo CActiveForm::validate($model);
                     }
                }
                    echo CJSON::encode($jsonData);
                
                }   catch(\yii\db\Exception $e){
                $jsonData['msg'] = "An error occured. Please try again";
                echo CJSON::encode($jsonData);
            }
        }
    }

    // action to get list of fixed asset register
    public function actionGetList() {
        $model = new FixedAssetMaster();
        $num = 0;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'er.fixed_asset_register_number',
            1 => 'em.fixed_asset_name',
            2 => 'er.invoice_id',
            3 => 'er.description',
            4 => 'er.depreciation_start_date',
            5 => 'ei.rate',
            6 => 'er.current_book_value'
        );
        //sort by fixest_asset_id
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        //sort by fixed asset type
        $filterColumn2 = $columns[$_POST['order'][1]['column']];
        $filterOrder2 = $_POST['order'][1]['dir'];
        $condition = '';
        $orderBy = $filterColumn . " " . $filterOrder. ",". $filterColumn2. " ". $filterOrder2;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (em.fixed_asset_name LIKE '%" . $searchString . "%' OR er.description LIKE '%" . $searchString . "%' OR er.fixed_asset_register_number LIKE '%" . $searchString . "%')";
        }
        
        $purchase_orders = $this->getFixedAssetRegister($condition, $limit, $offset, $orderBy);
        $count =  Yii::app()->db->createCommand()
                                                ->select('er.id, er.fixed_asset_register_number,er.invoice_id, er.product_id, er.serial_number, er.current_book_value ,er.depreciation_start_date, er.description, em.fixed_asset_name, ei.rate, es.part_number')
                                                ->from('erp_fixed_asset_register as er')
                                                ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                                                ->join('erp_purchasinginvoice_item as ei', 'er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id' )
                                                ->join('erp_store as es', 'er.product_id = es.id')
                                                ->where("er.isActive = :active $condition", array(':active' => 'Y'))
                                                ->queryAll(); 
        $count = count($count);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($purchase_orders as $row) {
            $div = '';
            $rowData[] = array(
                $row['fixed_asset_register_number'],
                $row['fixed_asset_name'],
                $row['invoice_id'],
                $row['description'],
                $row['depreciation_start_date'],
                number_format($row['rate'], 2, '.', ''),
                number_format($row['current_book_value'], 2, '.', ''), 
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id']),);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetSerialNumber($type = 'null', $param = 'null'){

        if ($param == 'null') $param = $_GET['fixed_asset_name'];

        $fixed_asset = Yii::app()->db->createCommand()
                                            ->select('max(fixed_asset_register_number) as number')
                                            ->from('erp_fixed_asset_register as fr')
                                            ->where('fr.fixed_asset_master_number = :number', array(':number' => $param ))
                                            ->queryRow();
        if (empty($fixed_asset['number'])){
            $fixed_asset = Yii::app()->db->createCommand()
                                            ->select('starting_series_number as number, starting_series_number as starting_number')
                                            ->from('erp_fixed_asset_master')
                                            ->where('id = :number', array(':number' => $param))
                                            ->queryRow();
        }
        if ($type == 'null'){
            echo CJSON::encode($fixed_asset);
        }else{
            return array (
                            'existing_series_number' => $fixed_asset['number'],
                            'series_number' => $fixed_asset['starting_number'],
                        );
        }
    }

    public function getPurchaseOrders(){
        $purchase_orders = Yii::app()->db->createCommand()
                                            ->select('file_id')
                                            ->from('erp_purchasinginvoice')
                                            ->where('isActive = :active', array(':active' => 'Y'))
                                            ->queryAll();
        foreach ($purchase_orders as $purchase_order){
            $purchase_order_dropdown[] = array('purchase_id' => $purchase_order['file_id'], 'purchase_values' => $purchase_order['file_id']);
        }
        return $purchase_order_dropdown;
    }

    public function actionGetInvoiceFromPurchase(){
        $invoices = Yii::app()->db->createCommand()
                                                ->select('epi.id, epi.file_id, epi.vendor_name, epii.description, epii.quantity, epii.rate, epi.invoice_date, es.part_number, epii.product_id')
                                                ->from('erp_purchasinginvoice as epi')
                                                ->join('erp_purchasinginvoice_item as epii', 'epi.id = epii.purchasing_invoice_id')
                                                ->join('erp_store as es', 'epii.product_id = es.id')
                                                ->where("epi.isActive = :active and epi.file_id = :purchase_order", array(':active' => 'Y', ':purchase_order' => $_GET['purchase_order']))
                                                 ->queryAll();
        $purchase_order =  $_GET['purchase_order'];                                         
       foreach ($invoices as $key => $invoice){
               foreach ($this->getFixedAssetRegister("and er.purchase_order = $purchase_order ") as $proid){
                    if($proid['product_id'] == $invoice['product_id']) unset($invoices[$key]);
               }
           }
           $invoice_data = array_values($invoices);
        echo CJSON::encode($invoice_data);
    }

    private function getFixedAssetRegister($condition = null, $limit = null, $offset = null, $orderBy = null){
        if ($limit == null && $offset == null && $orderBy == null){
            $purchase_orders = Yii::app()->db->createCommand()
                                            ->selectDistinct('er.product_id')
                                            ->from('erp_fixed_asset_register as er')
                                            ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                                            ->join('erp_purchasinginvoice_item as ei', 'er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id' )
                                            ->join('erp_store as es', 'er.product_id = es.id')
                                            ->where("er.isActive = :active $condition", array(':active' => 'Y'))                                            ->order($orderBy)
                                            ->queryAll();
        }else{
            $purchase_orders = Yii::app()->db->createCommand()
                                            ->select('er.id, er.fixed_asset_register_number,er.invoice_id, er.product_id, er.serial_number, er.current_book_value ,er.depreciation_start_date, er.description, em.fixed_asset_name, ei.rate, es.part_number')
                                            ->from('erp_fixed_asset_register as er')
                                            ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                                            ->join('erp_purchasinginvoice_item as ei', 'er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id' )
                                            ->join('erp_store as es', 'er.product_id = es.id')
                                            ->where("er.isActive = :active $condition", array(':active' => 'Y'))
                                            ->limit($limit)
                                            ->offset($offset)
                                            ->order($orderBy)
                                            ->queryAll();
        }
        
        return $purchase_orders;
    }

}
